<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Commande;
use App\Models\Facture;
use App\Models\Stock;
use App\Models\Client;
use App\Models\Categorie;
use App\Models\TypeVente;
use App\Models\ProduitUniteVente;

class CommandeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Commandes = Commande::whereEtatcommande(0)->get();
        return view('Commandes.index', compact('Commandes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    { 
      //Trouver la derniere Facture fait par utilisateur courant pour le en Passassion de commande  
      $NbreF = Facture::whereIdclientAndAuteur($request->CodeC, session()->get('Matricule'))->max('id');

      //recuperer les informations de cette derniere facture (surtout l'etat) 
      $EtatFs = Facture::whereId($NbreF)->get(['EtatFacture']);

      //Selection des informations de la nouvelle Facture
      $NvlleF = Facture::whereIdclientAndAuteurAndEtatfacture($request->CodeC, session()->get('Matricule'),'0')->max('id');
       $a = $NvlleF;

     //La Qte en Stock du produit commande
      $QsteStock = stock::findOrFail($request->Produit);

     $CurentYear = date('Y');
     //Selection du Dernier Enregistrement
     $MaxId = Facture::whereExercice($CurentYear)->max('id');

    //Cas du Bouton Suivant  
     if (isset($_POST['Suivant'])) 
     {   
        $this->validate($request, [
        'Quantite' => 'required|Numeric'
        ]); 
       
         // Conversion de la qte Commande En pieces
         $QteDemande = $request->Quantite;
         $QteUV = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
         $request->Quantite *= $QteUV->Qte;

        //Dans le cas ou l'Utilisateur courant aurait fait une facture a ce client  
        if ($NbreF > 0) 
        {
           //Comparer la qte Commande et celle en stock
           if ($QsteStock->quantiteStock >= $request->Quantite) 
           {
              //Diminution de la Qte en Stock
              $QsteStock->quantiteStock -= $request->Quantite;

              foreach ($EtatFs as $EtatF) 
              {
                 //Dans le cas cette facture est deja Finalisee
                 if ($EtatF->EtatFacture==1) 
                 {  

                   if ($MaxId>0) 
                   {   
                     //Selection des informations de l'enregistrement         avec coe Id = $MaxId
                      $InfoFacture = Facture::findOrFail($MaxId); 
                      $InfoFacture->Code +=1;
                      //On creee une nouvelle facture
                      Facture::create([
                      'idClient' => $request->CodeC,
                      'Client' => $request->Nom,
                      'Auteur' => session()->get('Matricule'),
                      'Exercice' => $CurentYear,
                      'Code' => $InfoFacture->Code
                      ]);
                   
                      //On recuperer les informations de cette derniere Facture (   son Id)
                      $NvlleF = Facture::whereIdclientAndAuteurAndEtatfacture($request->CodeC, session()->get('Matricule'),'0')->max('id');
                      $a = $NvlleF;

                       //Trouver le Montant Totale A Payer
                      $PrixProduit = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
                      $Totale =$QteDemande * $PrixProduit->PU;
                    
                    
                      //Creation des Commandes de cette Facture

                      Commande::create([
                          'Produit' => $request->Produit,
                          'Facture' => $a,
                          'Quantite' => $QteDemande,
                          'QtePiece' => $request->Quantite,
                          'Auteur' => session()->get('Matricule'),
                          'ProduitNom' => $QsteStock->Produit,
                          'UniteVente' => $request->TypeVente,
                          'Exercice' => $CurentYear, 
                          'Montant' => $Totale
                      ]);
                    }
                    else
                    {
                      Facture::create([
                      'idClient' => $request->CodeC,
                      'Client' => $request->Nom,
                      'Auteur' => session()->get('Matricule'),
                      'Exercice' => $CurentYear,
                      'Code' => 1
                      ]);
                   
                      //On recuperer les informations de cette derniere Facture (   son Id)
                      $NvlleF = Facture::whereIdclientAndAuteurAndEtatfacture($request->CodeC, session()->get('Matricule'),'0')->max('id');
                      $a = $NvlleF;

                      //Trouver le Montant Totale A Payer
                      $PrixProduit = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
                      $Totale =$QteDemande * $PrixProduit->PU;
                    
                      //Creation des Commandes de cette Facture

                      Commande::create([
                          'Produit' => $request->Produit,
                          'Facture' => $a,
                          'Quantite' => $QteDemande,
                          'QtePiece' => $request->Quantite,
                          'Auteur' => session()->get('Matricule'),
                          'ProduitNom' => $QsteStock->Produit,
                          'UniteVente' => $request->TypeVente,
                          'Exercice' => $CurentYear,
                          'Montant' => $Totale
                      ]);  
                    }    
                 }

                 //Dans le cas ou la facture n'est pas encore Finalisee
                 elseif($EtatF->EtatFacture==0)
                 {  
                    //Recupere les informations de la facture en cours (son Id)
                    $NvlleF = Facture::whereIdclientAndAuteurAndEtatfacture($request->CodeC, session()->get('Matricule'),'0')->max('id');
                    $a = $NvlleF;

                     //Trouver le Montant Totale A Payer
                      $PrixProduit = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
                      $Totale =$QteDemande * $PrixProduit->PU;
                    
                    
                    //Creation des Commandes de cette Facture
                    Commande::create([
                        'Produit' => $request->Produit,
                        'Facture' => $a,
                        'Quantite' => $QteDemande,
                        'QtePiece' => $request->Quantite,
                        'Auteur' => session()->get('Matricule'),
                        'ProduitNom' => $QsteStock->Produit,
                        'UniteVente' => $request->TypeVente,
                        'Exercice' => $CurentYear,
                        'Montant' => $Totale
                    ]);   
                 } 
              }
                //Mis a Jour de la Qte en stock
                $QsteUpdate  = Stock::findOrFail($request->Produit);
                $QsteUpdate->update([
                'quantiteStock' => $QsteStock->quantiteStock
                ]);
            }
            else
            {
              session()->flash('message', 'La Quantite en stock est insuffisante');
            }

        }

        //Dans le cas ou l'utilisateur courant n'a pas encore fait de facture pour ce Client
        else
        {
        
           //Comparer la qte Commande et celle en stock
           if ($QsteStock->quantiteStock >= $request->Quantite) 
           {  
              //Diminution de la Qte en Stock
              $QsteStock->quantiteStock -= $request->Quantite;
              if ($MaxId>0) 
              {   
                //Selection des informations de l'enregistrement         avec coe Id = $MaxId
                $InfoFacture = Facture::findOrFail($MaxId); 
                $InfoFacture->Code +=1;
                //Creation de la Nouvelle Facture
                Facture::create([
                 'idClient' => $request->CodeC,
                 'Client' => $request->Nom,
                 'Auteur' => session()->get('Matricule'),
                 'Exercice' => $CurentYear,
                 'Code' => $InfoFacture->Code
                 ]);
            
                 //Recuperation des informations de cette nouvelle Facture
                 $NvlleF = Facture::whereIdclientAndAuteurAndEtatfacture($request->CodeC, session()->get('Matricule'), '0')->max('id');
                 $a = $NvlleF;

                 //Trouver le Montant Totale A Payer
                  $PrixProduit = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
                  $Totale =$QteDemande * $PrixProduit->PU;
                    
                 //Creation des commandes de la Facture
                 Commande::create([
                     'Produit' => $request->Produit,
                     'Facture' => $a,
                     'Quantite' => $QteDemande,
                     'QtePiece' => $request->Quantite,
                     'Auteur' => session()->get('Matricule'),
                     'ProduitNom' => $QsteStock->Produit,
                     'UniteVente' => $request->TypeVente,
                     'Exercice' => $CurentYear,
                     'Montant' => $Totale
                 ]);
                 //Mis a Jour de la Qte en stock
                 $QsteUpdate  = Stock::findOrFail($request->Produit);
                 $QsteUpdate->update([
                 'quantiteStock' => $QsteStock->quantiteStock
                 ]);
               }
               else
               {
                  //Creation de la Nouvelle Facture
                  Facture::create([
                   'idClient' => $request->CodeC,
                   'Client' => $request->Nom,
                   'Auteur' => session()->get('Matricule'),
                   'Exercice' => $CurentYear,
                   'Code' => 1
                   ]);
            
                   //Recuperation des informations de cette nouvelle Facture
                   $NvlleF = Facture::whereIdclientAndAuteurAndEtatfacture($request->CodeC, session()->get('Matricule'), '0')->max('id');
                   $a = $NvlleF;

                    //Trouver le Montant Totale A Payer
                      $PrixProduit = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
                      $Totale =$QteDemande * $PrixProduit->PU;
                    
               
                   //Creation des commandes de la Facture
                   Commande::create([
                     'Produit' => $request->Produit,
                     'Facture' => $a,
                     'Quantite' => $QteDemande,
                     'QtePiece' => $request->Quantite,
                     'Auteur' => session()->get('Matricule'),
                     'ProduitNom' => $QsteStock->Produit,
                     'UniteVente' => $request->TypeVente,
                     'Exercice' => $CurentYear,
                     'Montant' => $Totale
                   ]);
                   //Mis a Jour de la Qte en stock
                   $QsteUpdate  = Stock::findOrFail($request->Produit);
                   $QsteUpdate->update([
                   'quantiteStock' => $QsteStock->quantiteStock
                    ]);
                }   
            }
            else
            {
               session()->flash('message', 'La Quantite en stock est insuffisante');
            }       
        }
     }
     //Cas du Boutons Finaliser
     elseif(isset($_POST['Finaliser']))
     {  
        //Calcule de la somme hors tva 
        $SommeThtva = Commande::whereAuteurAndFactureAndEtatcommande(session()->get('Matricule'), $a, '!=1')->sum('Montant');
        //Calcule de la somme avec tva
        $SommeTtvac = ($SommeThtva+(($SommeThtva*18)/100));
        
        //Mis a jour de la Facture (la somme hors tva et la somme avec tva)
        $Facture = Facture::findOrFail($a);
        $Facture->update(['Mhtva' => $SommeThtva, 'Mtvac' => $SommeTtvac, 'EtatFacture' => 1]);    
     }  
     $MontantT = Commande::whereFactureAndEtatcommande($a, '!=1')->sum('Montant');
     //Remplire le combobox des produits
     $UniteVentes = TypeVente::whereEtat('!=1')->get();
     $Stocks = Stock::whereEtatstock('!=1')->get();
     $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $Client = Client::findOrFail($request->CodeC);
     $Commandes = Commande::whereFacture($a)->paginate(5);
     $aNbre=Facture::whereIdclientAndEtatfacture($request->CodeC, 1)->count();
     if ($aNbre > 0) 
     {
       $a = Facture::whereIdclientAndEtatfacture($request->CodeC, 1)->max('id');
     }
     else
     {
      $a = 0;
     }  

     return redirect(route('Commandes.show',compact('Client'))); 
    }
 
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
     
     $Client = Client::findOrFail($id);
     
     $FactureNbre=Facture::whereIdclientAndEtatfacture($id, 0)->count();
     if ($FactureNbre > 0) 
     {
        $Facture = Facture::whereIdclientAndEtatfacture($id, 0)->first();
        $Commandes = Commande::whereFacture($Facture->id)->paginate(5);
        $MontantT = Commande::whereFactureAndEtatcommande($Facture->id, '!=1')->sum('Montant');
      }
      else
      {
        $MontantT = 0;
        $Commandes = [];
      }
     $UniteVentes = TypeVente::whereEtat('!=1')->get();  
     $Stocks = Stock::whereEtatstock('!=1')->get();
     $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $aNbre=Facture::whereIdclientAndEtatfacture($id, 1)->count();
     $NbreFactureNv=Facture::whereIdclientAndEtatfacture($id, 0)->count();
     if ($aNbre > 0) 
     {
       $a = Facture::whereIdclientAndEtatfacture($id, 1)->max('id');
     }
     else
     {
      $a = 0;
     }  
     
      $table="";
        $StockVar=Stock::where('EtatStock',0)->get();

         foreach($Commandes as $Commande){

            $Produit=$Commande->Produit;
            $ProdDetail=Stock::where('id',$Produit)->first();

            $UniteVente=$Commande->UniteVente;
            $Nbre=TypeVente::where('id',$UniteVente)->count('id');
            if($Nbre>0){
               $UniteVenteDetail=TypeVente::where('id',$UniteVente)->first();
            }else{
              $UniteVenteDetail= New TypeVente;
            } 
            
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$ProdDetail->Produit.' '.$ProdDetail->Propriete."</td>

                        <td>".$UniteVenteDetail->TypeVente."</td>
                        <td>".$Commande->Quantite."</td>
                        <td>".$Commande->Montant."</td>                        
                        <td class='center f-icon'>

                            <form action='".route('Commandes.destroy', $Commande)."' method='POST'>

                            <a href='".route('Commandes.edit', $Commande)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                            </form>
                        </td>
                      
                    </tr>";
                    }
        $tableListe=$table;
        // return view('Stock.index',compact('tableListe'));
     return view('Commandes.show', compact('Client', 'Commandes', 'Stocks', 'MontantT', 'a', 'Categories', 'UniteVentes', 'tableListe','NbreFactureNv'));  
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

     $Commande = Commande::findOrFail($id);
     $TypeVente = TypeVente::findOrFail($Commande->UniteVente);  
     $Stock = Stock::findOrFail($Commande->Produit);

     $UniteVentes = TypeVente::whereEtat('!=1')->get();  
     $Stocks = Stock::whereEtatstock('!=1')->get();

     $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $aNbre=Facture::whereIdclientAndEtatfacture($id, 1)->count();
     return view('Commandes.edit', compact('Stocks', 'MontantT', 'a', 'Categories', 'UniteVentes', 'Commande', 'Stock', 'TypeVente'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
        'Quantite' => 'required|Numeric'
        ]); 
        
        // Conversion de la qte Commande En pieces
        $QteDemande = $request->Quantite;
        $QteUV = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
        $request->Quantite *= $QteUV->Qte;

         //Trouver le Montant Totale A Payer
         $PrixProduit = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
         $Totale =$QteDemande * $PrixProduit->PU;
        //Remise de la Qte demandee en Stock
        $Commande = Commande::findOrFail($id);
        $Facture = Facture::findOrFail($Commande->Facture);
        $Stock = stock::findOrFail($Commande->Produit);

        // Conversion de la qte Commande En pieces
        //$QteDemande = $request->Quantite;
        // $QteUV = ProduitUniteVente::whereProduitAndTypevente($Commande->Produit,$Commande->UniteVente)->first();
        // $Commande->Quantite *= $QteUV->Qte;

        $Stock->quantiteStock+=$Commande->QtePiece;
        $Stock->update(['quantiteStock' => $Stock->quantiteStock]);

        //Modifiacation de la Commande
        $Commande->update([
            'Quantite' => $QteDemande,
            'QtePiece' => $request->Quantite,
            'Produit' => $request->Produit,
            'UniteVente' => $request->TypeVente,
            'Montant' => $Totale
        ]);
    
        //Calcule de la somme hors tva 
        $SommeThtva = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
        //Calcule de la somme avec tva
        $SommeTtvac = ($SommeThtva+(($SommeThtva*18)/100));
        //Modifiacation de la Facture
        $Facture->update(['Mhtva' => $SommeThtva, 'Mtvac' => $SommeTtvac]);    

        //Retranche de la Qte demande en stock
        //La Qte en Stock du produit commande
        $QsteStock = stock::findOrFail($request->Produit);

        // Conversion de la qte Commande En pieces
        //$QteDemande = $request->Quantite;
        $QteUV = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
        $QteDemande *= $QteUV->Qte;

        $QsteStock->quantiteStock -= $request->Quantite;

        //Mis a Jour de la Qte en stock
        $QsteUpdate  = Stock::findOrFail($request->Produit);
        $QsteUpdate->update([
        'quantiteStock' => $QsteStock->quantiteStock
        ]);   

     $MontantT = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
     //Remplire le combobox des produits
     // $UniteVentes = TypeVente::whereEtat('!=1')->get();
     // $Stocks = Stock::whereEtatstock('!=1')->get();
     // $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $ClientCode = Facture::findOrFail($Commande->Facture);
     $Client = Client::findOrFail($ClientCode->idClient);
     //$Commandes = Commande::whereFacture($Commande->Facture)->paginate(5);
     // return view('Clients.show',compact('Commandes', 'MontantT','Client', 'Stocks', 'Categories', 'UniteVentes'));

     return redirect(route('Commandes.show',compact('Client'))); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {  
        //On Change L'etat de la commande
        $Commande = Commande::findOrFail($id);
        $Facture = Facture::findOrFail($Commande->Facture);
        $Commande->update([
            'EtatCommande' => 1
        ]);
     
        //Calcule de la somme hors tva 
        $SommeThtva = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
        //Calcule de la somme avec tva
        $SommeTtvac = ($SommeThtva+(($SommeThtva*18)/100));
        //Modifiacation de la Facture
        $Facture->update(['Mhtva' => $SommeThtva, 'Mtvac' => $SommeTtvac]);    

        //Ajout de Qte du Stock 
        //La Qte en Stock du produit commande
        $QsteStock = stock::findOrFail($Commande->Produit);
        $QsteStock->quantiteStock += $Commande->QtePiece;

        //Mis a Jour de la Qte en stock
        $QsteUpdate  = Stock::findOrFail($Commande->Produit);
        $QsteUpdate->update([
        'quantiteStock' => $QsteStock->quantiteStock
        ]);   

     $MontantT = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
     //Remplire le combobox des produits
     $UniteVentes = TypeVente::whereEtat('!=1')->get();
     $Stocks = Stock::whereEtatstock('!=1')->get();
     $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $ClientCode = Facture::findOrFail($Commande->Facture);
     $Client = Client::findOrFail($ClientCode->idClient);
     $Commandes = Commande::whereFacture($Commande->Facture)->paginate(5);
     // return view('Clients.show',compact('Commandes', 'MontantT','Client', 'Stocks', 'Categories', 'UniteVentes'));
     return redirect(route('Commandes.show',compact('Client')));
    }


   //AFFICHAGE DE COMMANDES EN CORBEILLE
    public function CorbeleVente()
    {
      $Commandes = Commande::whereEtatcommande(1)->get();
      return view('Commandes.CorbeleVente', compact('Commandes'));
    }


    public function restauration($id)
    {
       //On Change L'etat de la commande
        $Commande = Commande::findOrFail($id);
        $Facture = Facture::findOrFail($Commande->Facture);
        $Commande->update([
            'EtatCommande' => 0
        ]);
     
        //Calcule de la somme hors tva 
        $SommeThtva = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
        //Calcule de la somme avec tva
        $SommeTtvac = ($SommeThtva+(($SommeThtva*18)/100));
        //Modifiacation de la Facture
        $Facture->update(['Mhtva' => $SommeThtva, 'Mtvac' => $SommeTtvac]);    

        //Ajout de Qte du Stock 
        //La Qte en Stock du produit commande
        $QsteStock = stock::findOrFail($Commande->Produit);
        $QsteStock->quantiteStock -= $Commande->QtePiece;

        //Mis a Jour de la Qte en stock
        $QsteUpdate  = Stock::findOrFail($Commande->Produit);
        $QsteUpdate->update([
        'quantiteStock' => $QsteStock->quantiteStock
        ]);   

     return redirect(route('CorbeleVente'));
    }


     public function getProduitCommande(Request $request){
        $CAT=$request->get('id_categorie');
        $produit=Stock::wherecategorieAndEtatstock($CAT,0)->get();
        $allProduit="<option selected='selected'>Selection unite vente</option>";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;

    }

        public function getTypeVente(Request $request){
        $prod=$request->get('idProduit');
        $produit=ProduitUniteVente::where('Produit',$prod)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $typevend=TypeVente::whereIdAndEtat($keyProduit->TypeVente,0)->first();
            $allProduit.="<option value='".$typevend->id."'>".$typevend->TypeVente."</option>";
        }
        echo $allProduit;

    }
}
