<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Stock;
use App\Models\Categorie;
use App\Models\Approvisionnement;
use App\Models\Commande;
use App\Models\ProduitUniteVente;
use App\Models\TypeVente;
use App\Models\Exclusion;
class StockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function index()
    {   
        $table="";
        $StockVar=Stock::where('EtatStock',0)->get();

         foreach($StockVar as $Produit){
            if ($Produit->quantiteStock < $Produit->QteMin) 
            {
            $cat=$Produit->Categorie;
            $categorie=Categorie::where('id',$cat)->first();
            $table.="
                    <tr class='odd gradeX alert alert-danger' style='height:20px;'>
                        <td>".$Produit->Produit."</td>
                        <td>".$Produit->Propriete."</td>
                        <td>".$categorie->Categorie."</td>
                        <td>".$Produit->quantiteStock."</td>
                        <td>".$Produit->QteMin."</td>
                        <td class='center f-icon'>
                            <form action='".route('Stock.destroy',$Produit->id)."' method='POST'>
                            <a href='".route('Stock.edit',$Produit->id)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                                    
                                <a href='".route('Stock.show',$Produit->id)."'><i class='fa fa-eye'></i></a>
                            </form>
                        </td>
                      
                    </tr>";
                    }
            elseif($Produit->quantiteStock == $Produit->QteMin)
            {
            $cat=$Produit->Categorie;
            $categorie=Categorie::where('id',$cat)->first();
            $table.="
                    <tr class='odd gradeX alert alert-info' style='height:20px;'>
                        <td>".$Produit->Produit."</td>
                        <td>".$Produit->Propriete."</td>
                        <td>".$categorie->Categorie."</td>
                        <td>".$Produit->quantiteStock."</td>
                        <td>".$Produit->QteMin."</td>
                        <td class='center f-icon'>
                            <form action='".route('Stock.destroy',$Produit->id)."' method='POST'>
                            <a href='".route('Stock.edit',$Produit->id)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                                    
                                <a href='".route('Stock.show',$Produit->id)."'><i class='fa fa-eye'></i></a>
                            </form>
                        </td>
                      
                    </tr>";
                    }
                    else
                    {
                                  $cat=$Produit->Categorie;
            $categorie=Categorie::where('id',$cat)->first();
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$Produit->Produit."</td>
                        <td>".$Produit->Propriete."</td>
                        <td>".$categorie->Categorie."</td>
                        <td>".$Produit->quantiteStock."</td>
                        <td>".$Produit->QteMin."</td>
                        <td class='center f-icon'>
                            <form action='".route('Stock.destroy',$Produit->id)."' method='POST'>
                            <a href='".route('Stock.edit',$Produit->id)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                                    
                                <a href='".route('Stock.show',$Produit->id)."'><i class='fa fa-eye'></i></a>
                            </form>
                        </td>
                      
                    </tr>";  
                    }
            }
        $tableListe=$table;
        return view('Stock.index',compact('tableListe'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categorie=Categorie::where('EtatCategorie',0)->get();
        return view('Stock.create',compact('categorie'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'Produit'=>'required',
            'categorie'=>'required',
            'Propriete' =>'required',
            'QteMin' => 'required'
        ]);
        $verf=Stock::whereProduitAndPropriete($request->Produit,$request->Propriete)->count('id');
        if ($verf==0) {
             Stock::create([
            'Produit'=>$request->Produit,
            'Propriete'=>$request->Propriete,
            'Categorie'=> $request->categorie,
            'QteMin' => $request->QteMin,
            'Auteur' => session()->get('Matricule')
            ]);
        }
        else
        {
          session()->flash('messageDelete', 'Cet Article Existe dans le Stock');
        }
       
      return redirect(route('Stock.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {   
        $Commandes = Commande::whereProduitAndEtatcommande($id, '!=1')->get();
        $MontantC = Commande::whereProduitAndEtatcommande($id, '!=1')->sum('Montant');
        $table="";
        
         foreach($Commandes as $Commande){

            $id_UniteVente=$Commande->UniteVente;
            $UniteVente=TypeVente::where('id',$id_UniteVente)->first();

            $table.="
                  <tr>
                    <td>".$UniteVente->TypeVente."</td>
                    <td>".$Commande->Quantite."</td>
                    <td>".$Commande->Montant."</td>
                    <td>".$Commande->Auteur."</td>
                </tr>";
                       
        }

        $tableListeSortie=$table;
        $Exclusions = Exclusion::whereProduitAndEtat($id, '!=1')->get();
        $MontantE = Exclusion::whereProduitAndEtat($id, '!=1')->sum('Montant');
        $Stocks = Stock::findOrFail($id);

         $table="";
        $PUUVNbre = ProduitUniteVente::whereProduit($id)->count();

        if ($PUUVNbre > 0) {

        $PUUVS = ProduitUniteVente::whereProduitAndEtat($id,0)->get();
         foreach($PUUVS as $PUUV){

            $id_Uv=$PUUV->TypeVente;
            $TypeVente=TypeVente::where('id',$id_Uv)->first();

            $table.="
                    <p>".$TypeVente->TypeVente." (".$PUUV->Qte." Pieces) : ".$PUUV->PU ." FBU<br />";
                    }
                       # code...
        }

        $tableListe=$table;
        
        $Approvisionnements = Approvisionnement::whereProduitAndEtatapp($id, '!=1')->get();
         $MontantA = Approvisionnement::whereProduitAndEtatapp($id, '!=1')->sum('Pt');
        return view('Stock.show', compact('Approvisionnements','Stocks', 'tableListeSortie', 'Exclusions', 'MontantC', 'MontantE', 'MontantA','tableListe'));
        //return view('Stocks.show')
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Produit=Stock::findOrFail($id);
        $categorie=Categorie::whereEtatcategorie(0)->get();
        $CatProd=Categorie::whereId($Produit->Categorie)->first();
        return view('Stock.edit',compact('categorie', 'Produit', 'CatProd'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'Produit'=>'required',
            'categorie'=>'required',
            'QteMin'=>'required',
            'Propriete'=>'required'
        ]);
        // $verification=Categorie::whereCategorie($request->cate)->count('id');
        // if ($verification==0) {
            # code...
        
        $prod=Stock::findOrFail($id);
        $prod->update([
            'Categorie'=> $request->categorie,
            'Produit' =>$request->Produit,
            'Propriete'=> $request->Propriete,
            'QteMin' =>$request->QteMin
            ]);
       return redirect(route('Stock.index'));
       // }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Stock=Stock::findOrFail($id);
        $Stock->update(['EtatStock'=>1]);
          return redirect(route('Stock.index'));
    }

    public function FicheStockEntree($id)
    {
     $SomApp = Approvisionnement::whereProduit($id)->sum('Quantite');   
     $Approvisionnements = Approvisionnement::whereProduit($id)->get();
     $SomComm = Commande::whereProduit($id)->sum('Quantite');
     $Commandes = Commande::whereProduit($id)->get();
     return view('Stock.FicheStockEntree', compact('Approvisionnements', 'Commandes', 'SomApp', 'SomComm'));
    }

    public function CorbeleStock()
    {
        $table="";
        $StockVar=Stock::where('EtatStock',1)->get();

         foreach($StockVar as $Produit){
            if ($Produit->quantiteStock < $Produit->QteMin) 
            {
            $cat=$Produit->Categorie;
            $categorie=Categorie::where('id',$cat)->first();
            $table.="
                    <tr class='odd gradeX alert alert-danger' style='height:20px;'>
                        <td>".$Produit->Produit."</td>
                        <td>".$Produit->Propriete."</td>
                        <td>".$categorie->Categorie."</td>
                        <td>".$Produit->quantiteStock."</td>
                        <td>".$Produit->QteMin."</td>
                        <td class='center f-icon'>
                            <a href='".route('restauration', $Commande)."'><img src='".url('icons/icons8_Reset_24px.png')."' width='20px' height='20px'></a>
                        </td>
                      
                    </tr>";
                    }
            elseif($Produit->quantiteStock == $Produit->QteMin)
            {
            $cat=$Produit->Categorie;
            $categorie=Categorie::where('id',$cat)->first();
            $table.="
                    <tr class='odd gradeX alert alert-info' style='height:20px;'>
                        <td>".$Produit->Produit."</td>
                        <td>".$Produit->Propriete."</td>
                        <td>".$categorie->Categorie."</td>
                        <td>".$Produit->quantiteStock."</td>
                        <td>".$Produit->QteMin."</td>
                        <td class='center f-icon'>
                            <a href='".route('restauration', $Commande)."'><img src='".url('icons/icons8_Reset_24px.png')."' width='20px' height='20px'></a>
                        </td>
                      
                    </tr>";
                    }
                    else
                    {
                                  $cat=$Produit->Categorie;
            $categorie=Categorie::where('id',$cat)->first();
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$Produit->Produit."</td>
                        <td>".$Produit->Propriete."</td>
                        <td>".$categorie->Categorie."</td>
                        <td>".$Produit->quantiteStock."</td>
                        <td>".$Produit->QteMin."</td>
                        <td class='center f-icon'>
                            <a href='".route('restaurationStock', $Produit)."'><img src='".url('icons/icons8_Reset_24px.png')."' width='20px' height='20px'></a>
                        </td>
                      
                    </tr>";  
                    }
            }
        $tableListe=$table;
        return view('Stock.CorbeleStock',compact('tableListe'));
    }

    public function restaurationStock($Produit)
    {
        $Stock=Stock::findOrFail($Produit);
        $Stock->update(['EtatStock'=>0]);
        return redirect(route('CorbeleStock'));
    }
}