<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCommandesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('commandes', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('Produit');
            $table->integer('UniteVente');
            $table->string('ProduitNom');
            $table->double('Quantite');
            $table->double('QtePiece');
            $table->double('Montant');
            $table->integer('Facture');
            $table->string('Auteur');
            $table->integer('EtatCommande');
            $table->dateTime('DateCreation')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->integer('Exercice');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('commandes');
    }
}
