<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->increments('id');
            $table->string('Nom');
            $table->string('Telephone');
            $table->string('Email');
            $table->string('Categorie');
            $table->string('Adresse');
            $table->integer('Assujetti');
            $table->string('Auteur');
            $table->dateTime('DateCreation')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->integer('EtatClient');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('clients');
    }
}
