@extends('layout.base', ['title' => 'StockApps - Affichage Ventes'])

@section('content')
        <div id="page-wrapper" >
            <div id="page-inner">
                <div class="row">
                    <div class="col-md-8">
                   </div>
                  <div class="col-md-4">
                    <div class="form-group input-group">
                        <span class="input-group-addon"><a target="blank" href="{{ url('Factures/pdfexport', $a) }}" style="color: white;text-decoration: none;"><img src=" {{ url('icons/icons8_Print_48px.png') }}" width="20px" height="20px"></a></span>
                          <input type="text" value="{{ $MontantT }}" class="form-control">
                        <span class="input-group-addon">FBU</span>
                    </div>
                  </div>
                </div>
                 <!-- /. ROW  -->
                 <hr />
               <div class="row">
                <div class="col-md-12">
                    <!-- Form Elements -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Enregistrement Nouveau Client
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                
                                    <form role="form" method="POST" action="{{ route('Commandes.store')}}">
                                      {{ csrf_field() }}
                                     <div class="col-md-12">
                                        <div class="form-group">
                                            <input class="form-control" readonly="" name="CodeC" value="{{ $Client->id }}" style="display: none;" />
                                        </div> 

                                        <div class="col-md-3">
                                           <div class="form-group">
                                            <input class="form-control" readonly="" name="Nom" value="{{ $Client->Nom }}"/>
                                           </div> 
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <input class="form-control" readonly="" name="Telephone" value="{{ $Client->Telephone }}"/>
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <input class="form-control" readonly="" name="Adresse" value="{{ $Client->Adresse }}"/>
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <input class="form-control" readonly="" name="Email" value="{{ $Client->Email }}"/>
                                          </div>  
                                        </div> 
                                     </div>
                                    
                                    <div class="col-md-12">
                                     <div class="col-md-3"> 
                                       <div class="form-group">
                                            <label>Categorie Produit</label>
                                            <select class="form-control" id="Categorie" onchange="getProduitCommande(this)">
                                               @foreach($Categories as $Cat)
                                               <option value="{{ $Cat->id }}">{{ $Cat->Categorie}}</option>
                                               @endforeach
                                            </select>
                                        </div>
                                      </div>
                                      
                                      <div class="col-md-3">
                                       <div class="form-group">
                                            <label>Produit</label>
                                            <select class="form-control" name="Produit" id="Produit" onchange="getTypeVente(this)">
                                              @foreach($Stocks as $Stock)  
                                                <option value="{{ $Stock->id}}">{{ $Stock->Produit}} {{ $Stock->Propriete}}</option>
                                               @endforeach 
                                            </select>
                                        </div>
                                      </div>

                                      <div class="col-md-3">
                                       <div class="form-group">
                                            <label>Vente:</label>
                                            <select class="form-control" name="TypeVente" id="TypeVente" required="required">
                                              @foreach($UniteVentes as $UniteVente)  
                                                <option value="{{ $UniteVente->id}}">{{ $UniteVente->TypeVente}}</option>
                                               @endforeach 
                                            </select>
                                        </div>
                                      </div>  
                                      
                                       <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Quantite en Piece</label>
                                            <input class="form-control" placeholder="Quantite" name="Quantite" value="{{ old('Quantite') }}" />

                                            {!! $errors->first('Quantite', '<span class="error">:message</span>') !!}
                                        </div>
                                       </div>

                                        <button type="submit" name="Suivant" class="btn btn-primary">Ajouter</button>

                                        @if($NbreFactureNv == 0)
                                        <button type="submit" disabled="" name="Finaliser" class="btn btn-primary">Terminer</button>
                                        @else
                                        <button type="submit" name="Finaliser" class="btn btn-primary">Terminer</button>
                                        @endif 
                                     </div>
                                    </form>
                                    <br />                   
                            </div> 
                            </div>
                        </div>
                    </div>
                     <!-- End Form Elements -->
                </div>


                                <!-- /. ROW  -->
            <div class="row">
                <div class="col-md-12">
                   
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Achat Encour .....
                        </div>
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Produit</th>
                                            <th>UV</th>
                                            <th>Quantite</th>
                                            <th>Montant</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                     <!-- @foreach ($Commandes as $Commande)
                                       @if($Commande->EtatCommande == 1)  
                                        <tr class="alert alert-danger">
                                            <td>{{ $Commande->id }}</td>
                                            <td>{{ $Commande->ProduitNom }}</td>
                                            <td>{{ $Commande->Quantite }}</td>
                                            <td>{{ $Commande->Montant }}</td>
                                            <td>
                                             <a href="{{ route('restauration', $Commande) }}"><img src="{{ url('icons/icons8_Reset_24px.png') }}" width="20px" height="20px"></a>
                                            </td>
                                        </tr>
                                        @else
                                          <tr>
                                            <td>{{ $Commande->id }}</td>
                                            <td>{{ $Commande->ProduitNom }}</td>
                                            <td>{{ $Commande->Quantite }}</td>
                                            <td>{{ $Commande->Montant }}</td>
                                            <td>
                                                <a href="{{ route('Commandes.edit', $Commande) }}"><img src="{{ url('icons/icons8_Edit_26px.png') }}" width="20px" height="20px"></a>

                                                <form action="{{ route('Commandes.destroy', $Commande)}}" method="POST" style="display: inline-block;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                    
                                                <input class="btn btn-danger btn-sm" type="submit" name="" value="Supprimer">
                                              </form>
                                            </td>
                                        </tr>
                                        @endif
                                       @endforeach  -->
                                       {!! $tableListe !!}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>
            </div>
    </div>
             <!-- /. PAGE INNER  -->
            </div>
         <!-- /. PAGE WRAPPER  -->
@endsection 

<script type="text/javascript">
   function getProduitCommande(va){
     var id_categorie= $(va).val();

      $.get('{{ route('getProduitCommande') }}',
          {id_categorie:id_categorie},
          function(data){
            $('#Produit').html(data);
          });
   }

      function getTypeVente(va){
     var idProduit= $(va).val();

      $.get('{{ route('getTypeVente') }}',
          {idProduit:idProduit},
          function(data){
            $('#TypeVente').html(data);
          });
   }
</script>