<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Models\Stock;
use App\Models\Commande;
use App\Models\Exclusion;
use App\Models\Approvisionnement;
use DB;

class JournalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //return view('Journals.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {  
       $Stocks = Stock::whereEtatstock('!=1')->get();
       return view('Journals.create', compact('Stocks'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $Date2 = $request->Fin;
        $Date1 = $request->debut;

    if (isset($_POST['Stocks'])) {    
        $Approv = Approvisionnement::whereProduit($request->Stocks)->whereBetween('DateCreation',[$Date1,$Date2])->get();

        $Commandes = Commande::whereProduit($request->Stocks)->whereBetween('DateCreation',[$Date1,$Date2])->get();

        $Exclusions = Exclusion::whereProduit($request->Stocks)->whereBetween('DateExclusion',[$Date1,$Date2])->get();

        $ApprovM = Approvisionnement::whereProduit($request->Stocks)->whereBetween('DateCreation',[$Date1,$Date2])->sum('Pt');

        $CommandesM = Commande::whereProduit($request->Stocks)->whereBetween('DateCreation',[$Date1,$Date2])->sum('Montant');

        $ExclusionsM = Exclusion::whereProduit($request->Stocks)->whereBetween('DateExclusion',[$Date1,$Date2])->sum('Montant');
        $Produit = Stock::findOrFail($request->Stocks);
        }
        else
        {
        $Approv = Approvisionnement::whereBetween('DateCreation',[$Date1,$Date2])->get();

        $Commandes = Commande::whereBetween('DateCreation',[$Date1,$Date2])->get();

        $Exclusions = Exclusion::whereBetween('DateExclusion',[$Date1,$Date2])->get();

        $ApprovM = Approvisionnement::whereBetween('DateCreation',[$Date1,$Date2])->sum('Pt');

        $CommandesM = Commande::whereBetween('DateCreation',[$Date1,$Date2])->sum('Montant');

        $ExclusionsM = Exclusion::whereBetween('DateExclusion',[$Date1,$Date2])->sum('Montant');
        $Produit = '';
        }

        $Resultat = $ApprovM-($ExclusionsM+$CommandesM);
        return view('Journals.index', compact('Approv', 'Commandes', 'Exclusions', 'ApprovM', 'CommandesM', 'ExclusionsM', 'Resultat', 'Date2', 'Date1', 'Produit'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
