<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Reception;
use App\Interfaces\IReception as IReception;
use App\Models\Commande;
use App\Interfaces\ICommande as ICommande;
use App\Models\Articlecommander;
use App\Interfaces\IArticlecommander as IArticlecommander;
use App\Models\Stock;
use App\Interfaces\IStock as IStock;
class ReceptionController extends Controller
{   

    public function __construct(IReception $Reception, ICommande $Commande, IArticlecommander $Articlecommander, IStock $Stock){
        $this->Reception = $Reception;
        $this->Commande = $Commande;
        $this->Articlecommander = $Articlecommander;
        $this->Stock = $Stock;
        $this->middleware('guest');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = $this->Reception->showitems();
        return view('Receptions.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $Commandes = $this->Commande->OrderNotReceived();
        $results=[];
        $Site='';
        return view('Receptions.create', compact('Commandes', 'results', 'Site'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       
        //dump($request['Identif']);
       $Qterecu = $request['Qterecu'];
       $IdentifR = $request['Identif'];
        $i=0;
        for ($i=0; $i <count($request['Identif']) ; $i++) { 
            $Quantite = (int)$Qterecu[$i];
            $Articlecommanderid = (int)$IdentifR[$i];
            
            $Received = $this->Reception->markReceived($Articlecommanderid);

             Reception::create([
            'Quantite'=>$Quantite,
            'Qtereste'=>$Quantite,
            'Articlecommanderid'=>$Articlecommanderid,
            'Remarque' => $request->Remarque,
            'Datereception'=>$request->Datereception,
            'recu'=>$Received,
            'Destination'=>$request->Destination,
            'Auteur' => session()->get('Matricule')
            ]);

            $Received = $this->Reception->markReceived($Articlecommanderid);

            //TROUVER LA QTE RECUE
            $QteReceived = $this->Reception->whereEtatAndArticlecommanderid(0,$Articlecommanderid)->sum('Quantite');
            $Article = Articlecommander::findOrFail($Articlecommanderid);
            $Article->update([
            'recu'=>$Received,
            'Qterecu'=>$QteReceived
            ]); 

            $this->Stock->ajouterstock($Article->Articleid, $request->Destination, $Quantite);
        }

        $this->Commande->markReceived($Article->Commandeid);
        return redirect(route('Receptions.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function display_article_ordered(Request $request){
        $Commandes = $this->Commande->OrderNotReceived();
        if (isset($request->Commande)) {
            $results = $this->Commande->ArticleAttachedToOrder($request->Commande);
            $Site = $this->Commande->showitem($request->Commande);
            $Site = $Site->Site;
        }else{
           $results=[]; 
        }
       
       return view('Receptions.create', compact('Commandes', 'results', 'Site'));
    }

  
    public function  Mouvements(){
        
    }
}
