<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Reception;
use App\Interfaces\IReception as IReception;
use App\Models\Commande;
use App\Interfaces\ICommande as ICommande;
use App\Models\Site;
use App\Interfaces\ISite as ISite;
use App\Models\Articlecommander;
use App\Models\Utilisateur;
use App\Interfaces\IArticlecommander as IArticlecommander;
use App\Models\Stock;
use App\Interfaces\IStock as IStock;
use App\Models\Transfer;
use App\Interfaces\ITransfer as ITransfer;
class TransfertController extends Controller
{  

     public function __construct(IReception $Reception, ICommande $Commande, IArticlecommander $Articlecommander, ISite $Site, IStock $Stock, ITransfer $Transfer){
        $this->Reception = $Reception;
        $this->Commande = $Commande;
        $this->Articlecommander = $Articlecommander;
        $this->Site = $Site;
        $this->Stock = $Stock;
        $this->Transfer = $Transfer;
        $this->middleware('guest');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $results = $this->Transfer->showitems();
        return view('Transfers.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $Sites = $this->Site->showitems();
        $results = [];
        $Utilisateurs = Utilisateur::all();
        return view('Transfers.create', compact('results', 'Sites', 'Utilisateurs'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
            $Reception = $this->Reception->showitem($request->Reception);
            
            $Article = Articlecommander::findOrFail($Reception->Articlecommanderid);
            $this->Stock->soustrairestock($Article->Articleid, $request->Origine, $request->Quantite);
            $this->Stock->ajouterstock($Article->Articleid, $request->Destination, $request->Quantite);

             Reception::create([
            'Quantite'=>$request->Quantite,
            'Qtereste'=>$request->Quantite,
            'Origine'=>$request->Origine,
            'Articlecommanderid'=>$Reception->Articlecommanderid,
            'Remarque' => $Reception->Remarque,
            'Destination'=>$request->Destination,
            'Auteur' => session()->get('Matricule')
            ]);
        return redirect(route('Receptions.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function display_stock_available(Request $request){
       $Sites = $this->Site->showitems();
      
        if (isset($request->Site)) {
            $results = $this->Reception->availablestock($request->Site);
        }else{
           $results=[]; 
        }
       $Utilisateurs = Utilisateur::all();
       return view('Transfers.create', compact('Sites', 'results', 'Utilisateurs'));
    }

    public function getReceptionId(Request $request){
        $ReceptId = $request->get('Reception');
        $Receptions = Reception::whereId($ReceptId)->get();
       

        $ReceptionDetail="";
        foreach ($Receptions as $Reception) {
            $ReceptionDetail =  $Reception->id.'#'.$Reception->Destination;
        }
        
        echo  $ReceptionDetail;
    }


}
