<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::post('/', 'ConnexionController@index')->name('index');
Route::get('/Deconnexion', 'ConnexionController@Deconnexion')->name('Deconnexion');

Route::resource('Clients', 'ClientController');
Route::resource('Sites', 'SiteController');
Route::resource('Article', 'ArticleController');
Route::resource('Receptions', 'ReceptionController');
Route::resource('Exclusions', 'ExclusionController');
Route::resource('Commandes', 'CommandeController');
Route::resource('Factures', 'FactureController');
Route::resource('Utilisateurs', 'UtilisateurController');
Route::resource('Fournisseurs', 'FournisseurController');
Route::resource('Taxes', 'TaxeController');
Route::resource('Transfers', 'TransfertController');
Route::resource('Transporteurs', 'TransporteurController');
Route::get('getArticleInformation', 'ArticleController@getArticleInformation')->name('getArticleInformation');
Route::get('maketotaux', 'ArticleController@maketotaux')->name('maketotaux');
Route::post('display_article_ordered', 'ReceptionController@display_article_ordered')->name('display_article_ordered');
Route::post('display_stock_available', 'TransfertController@display_stock_available')->name('display_stock_available');
Route::get('getReceptionId', 'TransfertController@getReceptionId')->name('getReceptionId');

Route::get('Mouvements', 'ReceptionController@Mouvements')->name('Mouvements');

Route::get('Commandes/restauration/{Commande}', 'CommandeController@restauration')->name('restauration');

Route::get('research', 'ApprovisionnementController@research')->name('research');

Route::get('restaurationStock/{Stock}', 'StockController@restaurationStock')->name('restaurationStock');

Route::get('restaurationAchat/{Achat}', 'ApprovisionnementController@restaurationAchat')->name('restaurationAchat');

Route::get('restaurationExclusion/{Exclusion}', 'ExclusionController@restaurationExclusion')->name('restaurationExclusion');

Route::get('restaurationClient/{Client}', 'ClientController@restaurationClient')->name('restaurationClient');

Route::get('restaurationTypeVente/{TypeVente}', 'TypeVenteController@restaurationTypeVente')->name('restaurationTypeVente');

Route::get('restaurationCategorie/{Categorie}', 'CategorieController@restaurationCategorie')->name('restaurationCategorie');

Route::get('restaurationPUV/{PUV}', 'ProduitUniteVenteController@restaurationPUV')->name('restaurationPUV');

Route::get('Factures/restauration/{Facture}', 'FactureController@restauration')->name('restaurationFacture');

Route::get('Utilisateurs/restauration/{Utilisateur}', 'UtilisateurController@restauration')->name('restaurationUtilisateur');

Route::get('Utilisateurs/ShowProfiluser/{Utilisateur}', 'UtilisateurController@ShowProfiluser')->name('ShowProfiluser');

Route::put('Utilisateurs/updateProfil/{Utilisateur}', 'UtilisateurController@updateProfil')->name('updateProfil');

Route::get('/TableauDeBord', 'TableauDeBordController@TableauDeBord')->name('TableauDeBord');

Route::post('/main/Verification', 'ConnexionController@Verification')->name('Verification');
Route::get('Factures/pdfexport/{id}', 'FactureController@pdfexport')->name('pdfexport');

Route::resource('Categories', 'CategorieController');
Route::resource('Stock', 'StockController');
Route::get('Stocks/FicheStockEntree/{Produit}', 'StockController@FicheStockEntree')->name('FicheStockEntree');
Route::resource('Approv', 'ApprovisionnementController');

Route::get('Archives/Archive', 'ArchiveController@ArchiveAchat')->name('ArchiveAchat');

Route::get('ArchiveAnnuelAchat/{Exercice}', 'ArchiveController@ArchiveAnnuelAchat')->name('ArchiveAnnuelAchat');

Route::get('ArchiveAnnuelVente/{Exercice}', 'ArchiveController@ArchiveAnnuelVente')->name('ArchiveAnnuelVente');

Route::get('ArchiveAnnuelExclusion/{Exercice}', 'ArchiveController@ArchiveAnnuelExclusion')->name('ArchiveAnnuelExclusion');

Route::get('ArchiveAnnuelFacture/{Exercice}', 'ArchiveController@ArchiveAnnuelFacture')->name('ArchiveAnnuelFacture');

Route::resource('TypeVentes', 'TypeVenteController');
Route::resource('ProduitUniteVentes', 'ProduitUniteVenteController');

Route::get('getProduit', 'ApprovisionnementController@getProduit')->name('getProduit');
Route::get('getProduitCommande', 'CommandeController@getProduitCommande')->name('getProduitCommande');
Route::get('getTypeVente', 'CommandeController@getTypeVente')->name('getTypeVente');

Route::get('CorbeleStock', 'StockController@CorbeleStock')->name('CorbeleStock');

Route::get('CorbeleAchat', 'ApprovisionnementController@CorbeleAchat')->name('CorbeleAchat');

Route::get('CorbeleVente', 'CommandeController@CorbeleVente')->name('CorbeleVente');

Route::get('CorbeleExclusion', 'ExclusionController@CorbeleExclusion')->name('CorbeleExclusion');

Route::get('CorbeleFacture', 'FactureController@CorbeleFacture')->name('CorbeleFacture');

Route::get('CorbeleClient', 'ClientController@CorbeleClient')->name('CorbeleClient');

Route::get('CorbeleUser', 'UtilisateurController@CorbeleUser')->name('CorbeleUser');

// Route::post('Activation', 'ConnexionController@Activation')->name('Activation');

Route::get('CorbeleTypeVente', 'TypeVenteController@CorbeleTypeVente')->name('CorbeleTypeVente');

Route::get('CorbeleCategorie', 'CategorieController@CorbeleCategorie')->name('CorbeleCategorie');

Route::get('CorbelePUV', 'ProduitUniteVenteController@CorbelePUV')->name('CorbelePUV');

Route::resource('Journals', 'JournalController');
Route::get('graphic', 'TableauDeBordController@graphic')->name('graphic');
Route::get('graphicA', 'ArchiveController@graphicA')->name('graphicA');
