<?php

namespace App\Models;
use App\Interfaces\IArticle as IArticle;
use Illuminate\Database\Eloquent\Model;
use DB;
class Article extends Model implements IArticle
{
    protected $table = 'articles';
    protected $fillable = ['Code', 'Description', 'Categorie', 'Coutachat', 'Prixvente', 'Taxe', 'Unitemesure', 'Notearticle', 'Etat', 'Auteur'];
    
    public function setCodeAttribute($value)
    {
        $this->attributes['Code'] = strtoupper($value);
    }

     public function showitems(){
       return $results = DB::table('articles')
                         ->join('taxes', 'taxes.id', '=', 'articles.Taxe')
                         ->select(DB::raw('articles.id, articles.Code, articles.Description, articles.Categorie, articles.Coutachat, articles.Prixvente,articles.Unitemesure,articles.Notearticle,articles.Etat,articles.Auteur,taxes.Taxe'))
                         ->where('articles.Etat', 0)
                         ->get();
     }
    
        
        public static function NbreCode ($value){
        $NbreCode = Article::whereCode($value)->count('id');
        
        if ($NbreCode>0) {
            return true;
        }
        else
        {
            return false;
        }
    }

     public static function NbreCodeUpdate ($value,$id){
        $NbreCode = Article::whereCode($value)->where('id', '!=', $id)->count('id');
        
        if ($NbreCode>0) {
            return true;
        }
        else
        {
            return false;
        }
    }

     public function savedata($request, $id){

        
         if (is_null($id)) {

            if($this->NbreCode($request->Code)==false){
                $this::create([
                'Code'=>$request->Code,
                'Description'=>$request->Description,
                'Categorie'=> $request->Categorie,
                'Coutachat' => $request->Coutachat,
                'Prixvente'=>$request->Prixvente,
                'Taxe'=>$request->Taxe,
                'Unitemesure'=>$request->Unitemesure,
                'Notearticle'=>$request->Notearticle,
                'Auteur' => session()->get('Matricule')
                ]);
            }else {
                //Message D'erreur
            }
            
         }else{
            
            $result = $this->showitem($id);
            if($this->NbreCodeUpdate($request->Code,$id)==false){ 
                $result->update([   
                'Code'=>$request->Code,
                'Description'=>$request->Description,
                'Categorie'=> $request->Categorie,
                'Coutachat' => $request->Coutachat,
                'Prixvente'=>$request->Prixvente,
                'Taxe'=>$request->Taxe,
                'Unitemesure'=>$request->Unitemesure,
                'Notearticle'=>$request->Notearticle,
                'Auteur' => session()->get('Matricule')
                ]);
            }else {
                //Message D'erreur
            }

        }

    }

    public function showitem($id){
    	return $this::findOrFail($id);
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);
         session()->flash('messageDelete', 'Article supprimé avec success');
     }
}
