<?php

namespace App\Models;
use App\Interfaces\IArticlecommander as IArticlecommander;
use Illuminate\Database\Eloquent\Model;
use App\Models\Commande;
class Articlecommander extends Model implements IArticlecommander
{
    protected $table = 'articlescommanders';
    protected $fillable = ['Quantite', 'Articleid', 'Commandeid', 'Taxe', 'Valeurunitaire', 'Totalunitaire', 'Auteur', 'Etat', 'recu', 'Qterecu'];
    
     public function showitems(){
       return $this->get();
     }

     public function savedata($request, $id){

        
         if (is_null($id)) {
             $this::create([
            'Quantite'=>$request->Quantite,
            'Articleid'=>$request->Articleid,
            'Taxe' => $request->Taxe,
            'Valeurunitaire'=>$request->Valeurunitaire,
            'Totalunitaire'=>$request->Quantite*$request->Valeurunitaire,
            'Auteur' => session()->get('Matricule')
            ]);
       
         }else{
            
            $result = $this->showitem($id);

            $result->update([
            'Quantite'=>$request->Quantite,
            'Article'=>$request->Article,
            'Description'=> $request->Description,
            'Taxe' => $request->Taxe,
            'Valeurunitaire'=>$request->Valeurunitaire,
            'Totalunitaire'=>$request->Quantite*$request->Valeurunitaire,
            'Auteur' => session()->get('Matricule')
            ]);
         }

    }

    public function showitem($id){
    	return $this::findOrFail($id);
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);
         session()->flash('messageDelete', 'Article supprimé avec success');
     }

     public function articleordering(){
        return $this::whereCommandeidAndEtatAndAuteur(0,0,session()->get('Matricule'))->get();
     }

     public function AttributeArticleToOrder($Order){
        $Articles = $this->articleordering();

        foreach ($Articles as $Article) {
            $Art = $this->showitem($Article->id);
            $Art->update([
                'Commandeid'=>$Order
            ]);
        }
     }

     public function FindArticleOrderedByOrder($Order){
        return $this::whereCommandeidAndEtat($Order,0)->get();
     }
}
