<?php

namespace App\Models;
use App\Interfaces\IReception as IReception;
use Illuminate\Database\Eloquent\Model;
use App\Models\Articlecommander;
use DB;
class Reception extends Model implements IReception
{
    protected $table = 'receptions';
    protected $fillable = ['Quantite', 'Articlecommanderid', 'Remarque', 'Datereception', 'Auteur', 'Etat', 'recu', 'Destination', 'Qtereste', 'Origine'];
    
     public function showitems(){
       return $this::whereOrigine(0)->get();
     }

     public function savedata($request, $id){

        
         if (is_null($id)) {
            $this::create([
            'Quantite'=>$request->Quantite,
            'Articlecommanderid'=>$request->Articlecommanderid,
            'Remarque' => $request->Remarque,
            'Datereception'=>$request->Datereception,
            'Destination'=>$request->Destination,
            'Auteur' => session()->get('Matricule')
            ]);
       
         }else{
            
            $result = $this->showitem($id);

            $result->update([
            'Quantite'=>$request->Quantite,
            'Articlecommanderid'=>$request->Articlecommanderid,
            'Remarque' => $request->Remarque,
            'Datereception'=>$request->Datereception,
            'Destination'=>$request->Destination,
            'Auteur' => session()->get('Matricule')
            ]);
         }

    }

    public function showitem($id){
    	return $this::findOrFail($id);
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);
         session()->flash('messageDelete', 'Article supprimé avec success');
     }

     public function markReceived($id){
       $QteReceived = $this::whereArticlecommanderid($id)->sum('Quantite');
       $QteOrdered = Articlecommander::whereId($id)->sum('Quantite');
       $QteOrdered = (int)$QteOrdered;
       $QteReceived = (int)$QteReceived;

       if($QteReceived==$QteOrdered){
           return $Response = 1;
       }elseif($QteReceived<$QteOrdered){
           return $Response = 0;
       }
    }

    public function Mouvements(){
         
         // $Articles = DB::table('articles')
         //             ->join('categories', 'categories.Code', '=', 'articles.Categorie')
         //             ->join('taxes', 'taxes.id', '=', 'articles.Taxe')
         //             ->join('sites', 'sites.id', '=', 'articles.Site')
         //             ->join('commandes', 'commandes.id')
         //             ->join('receptions', 'receptions.id', '=', 'articles.id')
    }


    public function availablestock($site){
      return  $results = DB::table('receptions')
                         ->join('sites', 'sites.id', '=', 'receptions.Destination')
                         ->join('articlescommanders', 'articlescommanders.id', '=', 'receptions.Articlecommanderid')
                         ->join('articles', 'articles.id', '=', 'articlescommanders.Articleid')
                         ->select(DB::raw('articles.Code, articles.Description, sum(receptions.Qtereste) as Qtereste, receptions.Articlecommanderid, receptions.Destination, receptions.id, sites.Nom'))
                         ->where('receptions.Destination',$site)->where('receptions.Etat',0)->groupBy('articles.id')->get();
    }
}
