<?php

namespace App\Models;
use App\Interfaces\ISite as ISite;
use Illuminate\Database\Eloquent\Model;

class Site extends Model implements ISite
{
    protected $table = 'sites';
    protected $fillable = ['Nom', 'Adresse','Etat', 'Auteur'];
     

     public function showitems(){
        return $this->get();
     }

     public function savedata($request, $id){

        
         if (is_null($id)) {
             $this::create([
            'Nom'=>$request->Nom,
            'Adresse'=>$request->Adresse,
            'Auteur' => session()->get('Matricule')
            ]);
       
         }else{
            
            $result = $this->showitem($id);
            $result->update([
            'Nom'=>$request->Nom,
            'Adresse'=>$request->Adresse,
            'Auteur' => session()->get('Matricule')
            ]);
         }

    }

    public function showitem($id){
    	return $this::findOrFail($id);
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);

         session()->flash('messageDelete', 'Site supprimé avec success');
     }
}
