<?php

namespace App\Models;
use App\Interfaces\IStock as IStock;
use Illuminate\Database\Eloquent\Model;

class Stock extends Model implements IStock
{   
	protected $table = 'stocks';
    protected $fillable = ['Siteid','Articleid', 'Quantite', 'Quantiteideal','Quantitesecurite', 'Etat', 'Auteur'];

    public function showitems(){
        return $this->get();
    } 
    public function savedata($request, $id){

         if (is_null($id)) {
             $this::create([
            'Siteid'=>$request->Siteid,
            'Articleid'=>$request->Articleid,
            'Quantiteideal' => $request->Quantiteideal,
            'Quantitesecurite'=>$request->Quantitesecurite,
            'Auteur' => session()->get('Matricule')
            ]);
       
         }else{
            
            $result = $this->showitem($id);

            $result->update([
            'Siteid'=>$request->Siteid,
            'Articleid'=>$request->Articleid,
            'Quantiteideal' => $request->Quantiteideal,
            'Quantitesecurite'=>$request->Quantitesecurite,
            'Auteur' => session()->get('Matricule')
            ]);
         }

    }

    public function showitem($id){
    	return $this->whereArticleid($id)->get();
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);

         session()->flash('messageDelete', 'stock supprimé avec success');
     }

     public function ajouterstock($Article, $Site, $Quantite){
        $Stock = $this::whereArticleidAndSiteid($Article,$Site)->first();
        $Stock->update([
            'Quantite'=>$Stock->Quantite+$Quantite
        ]);
     }
     public function soustrairestock($Article, $Site, $Quantite){
        $Stock = $this::whereArticleidAndSiteid($Article,$Site)->first();
        $Stock->update([
            'Quantite'=>$Stock->Quantite-$Quantite
        ]);
     }
}
