<?php

namespace App\Models;
use App\Interfaces\ITaxe as ITaxe;
use Illuminate\Database\Eloquent\Model;

class taxe extends Model implements ITaxe
{
    protected $table = 'taxes';
    protected $fillable = ['Taxe', 'Montant','Etat', 'Auteur', 'Default'];
     

     public function showitems(){
        return $this->get();
     }

     public function savedata($request, $id){

        
         if (is_null($id)) {
             $this::create([
            'Taxe'=>$request->Taxe,
            'Montant'=>$request->Montant,
            'Auteur' => session()->get('Matricule'),
            'Default' => $request->Default
            ]);
       
         }else{
            
            $result = $this->showitem($id);
            $result->update([
            'Taxe'=>$request->Taxe,
            'Montant'=>$request->Montant,
            'Auteur' => session()->get('Matricule'),
            'Default' => $request->Default
            ]);
         }

    }

    public function showitem($id){
    	return $this::findOrFail($id);
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);

         session()->flash('messageDelete', 'Taxe supprimé avec success');
     }

     public function findDefaultTaxe(){
        return $this::whereDefaultAndEtat(1,0)->first();
     }
}
